<?php

include "../painel/config/db.php";
include "../painel/config/functions.php";


$vinhosBrancosSql = "SELECT * from vinhos inner join nacionalidade on nacionalidade.id = vinhos.nacionalidade where tipo_vinho = 'branco'";
$vinhosBrancos = mysqli_query(db_connect(), $vinhosBrancosSql) or die(mysqli_error(db_connect()));


$vinhosRosesSql = "SELECT * from vinhos inner join nacionalidade on nacionalidade.id = vinhos.nacionalidade where tipo_vinho = 'rosé'";
$vinhosRoses = mysqli_query(db_connect(), $vinhosRosesSql) or die(mysqli_error(db_connect()));

$vinhosTintosSql = "SELECT * from vinhos inner join nacionalidade on nacionalidade.id = vinhos.nacionalidade where tipo_vinho = 'tinto'";
$vinhosTintos = mysqli_query(db_connect(), $vinhosTintosSql) or die(mysqli_error(db_connect()));

$champagneSql = "SELECT * from vinhos inner join nacionalidade on nacionalidade.id = vinhos.nacionalidade where tipo_vinho = 'champagne'";
$champagne = mysqli_query(db_connect(), $champagneSql) or die(mysqli_error(db_connect()));


?>


<!doctype html>
<html lang="en" data-bs-theme="auto">

<head>
  <script src="/docs/5.3/assets/js/color-modes.js"></script>

  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="">
  <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">
  <meta name="generator" content="Hugo 0.118.2">
  <title>Carta de Vinhos</title>

  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@docsearch/css@3">
  <link rel="stylesheet" href="./assets/css/style.css">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">

  <!-- Favicons -->
  <link rel="apple-touch-icon" href="/docs/5.3/assets/img/favicons/apple-touch-icon.png" sizes="180x180">
  <link rel="icon" href="/docs/5.3/assets/img/favicons/favicon-32x32.png" sizes="32x32" type="image/png">
  <link rel="icon" href="/docs/5.3/assets/img/favicons/favicon-16x16.png" sizes="16x16" type="image/png">
  <link rel="manifest" href="/docs/5.3/assets/img/favicons/manifest.json">
  <link rel="mask-icon" href="/docs/5.3/assets/img/favicons/safari-pinned-tab.svg" color="#712cf9">
  <link rel="icon" href="/docs/5.3/assets/img/favicons/favicon.ico">
  <meta name="theme-color" content="#712cf9">



  <link href="carousel.css" rel="stylesheet">
</head>

<body>
  <main>

    <!-- carrossel -->
    <div id="myCarousel" class="carousel slide mb-6" data-bs-ride="carousel">

      <div class="carousel-inner">
        <div class="carousel-item img-back active">
          <svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false">
            <rect width="100%" height="100%" fill="var(--bs-secondary-color)" />
          </svg>
          <div class="container">

          </div>
        </div>


      </div>

    </div>
    <!-- fim carrossel -->

    <div class="foto-informacoes">
    
      <div class="foto">
        <img src="./assets/img/logo.jpg" alt="logo da cadas orientales" width="200">
      </div>

    </div>
    
     <div class="linkMenu" style="display: flex; align-items: center; justify-content: center">
          <a href="https://casaorientales.com.br/vinhos/cardapio/">Voltar ao Cardápio Geral</a>
      </div>


    <ul class="nav nav-tabs tab-vinhos" id="myTab" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">Brancos</button>
      </li>

      <li class="nav-item" role="presentation">
        <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">Rosés</button>
      </li>

      <li class="nav-item" role="presentation">
        <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab" aria-controls="contact" aria-selected="false">Tintos</button>
      </li>

      <li class="nav-item" role="presentation">
        <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#champagne" type="button" role="tab" aria-controls="champagne" aria-selected="false">Champagnes</button>
      </li>
    </ul>

    <div class="tab-content" id="myTabContent">
      <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">

        <div class="tab-title">
          <h5>Vinhos Brancos</h5>
          <hr>
        </div>





        <input class="form-control" id="myInput" type="text" placeholder="Pesquisar..">

        <div class="table-responsive">
          <table class="table mb-0">
            <thead>
              <tr>
                <th></th>
                <th></th>
              </tr>
            </thead>
            <tbody id="myTable">
              <?php while ($dado = $vinhosBrancos->fetch_array()) { ?>
                <tr>
                  <td><?php echo $dado['nome']; ?>
                    <span class="descricao-vinho"><?php echo $dado['descricao'] ?></span>
                    <p class="preco-vinho">R$ <?php echo $dado['preco'] ?></p>
                    <div class="foto-origem">
                      <img src="../painel/assets/images/fotos/<?php echo $dado['bandeira']; ?>" alt="" width="50px">
                    </div>
                  </td>

                  <td><img src="../painel/assets/images/fotos/<?php echo  $dado['foto']; ?>" alt="" width="80px" style="border-radius:100%"></td>
                </tr>

              <?php } ?>


            </tbody>
          </table>
        </div>




      </div>




      <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
        <div class="tab-title">
          <h5>Vinhos Rosés</h5>
          <hr>
        </div>


        <input class="form-control" id="myInputRose" type="text" placeholder="Pesquisar..">

        <div class="table-responsive">
          <table class="table mb-0">
            <thead>
              <tr>
                <th></th>
                <th></th>
              </tr>
            </thead>
            <tbody id="myTableRose">
              <?php while ($dado = $vinhosRoses->fetch_array()) { ?>
                <tr>
                  <td><?php echo $dado['nome']; ?>
                    <span class="descricao-vinho"><?php echo $dado['descricao'] ?></span>
                    <p class="preco-vinho">R$ <?php echo $dado['preco'] ?></p>
                    <div class="foto-origem">
                      <img src="../painel/assets/images/fotos/<?php echo $dado['bandeira']; ?>" alt="" width="50px">
                    </div>
                  </td>

                  <td><img src="../painel/assets/images/fotos/<?php echo  $dado['foto']; ?>" alt="" width="80px" style="border-radius:100%"></td>
                </tr>

              <?php } ?>


            </tbody>
          </table>
        </div>







      </div>
      <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
        <div class="tab-title">
          <h5>Vinhos Tintos</h5>
          <hr>
        </div>

        <input class="form-control" id="myInputTintos" type="text" placeholder="Pesquisar..">

        <div class="table-responsive">
          <table class="table mb-0">
            <thead>
              <tr>
                <th></th>
                <th></th>
              </tr>
            </thead>
            <tbody id="myTableTintos">
              <?php while ($dado = $vinhosTintos->fetch_array()) { ?>
                <tr>
                  <td><?php echo $dado['nome']; ?>
                    <span class="descricao-vinho"><?php echo $dado['descricao'] ?></span>
                    <p class="preco-vinho">R$ <?php echo $dado['preco'] ?></p>
                    <div class="foto-origem">
                      <img src="../painel/assets/images/fotos/<?php echo $dado['bandeira']; ?>" alt="" width="50px">
                    </div>
                  </td>

                  <td><img src="../painel/assets/images/fotos/<?php echo  $dado['foto']; ?>" alt="" width="80px" style="border-radius:100%"></td>
                </tr>

              <?php } ?>


            </tbody>
          </table>
        </div>




      </div>


      <div class="tab-pane fade" id="champagne" role="tabpanel" aria-labelledby="champagne-tab">
        <div class="tab-title">
          <h5>Champagnes e Espumantes</h5>
          <hr>
        </div>


        <input class="form-control" id="myInputChampagne" type="text" placeholder="Pesquisar..">

        <div class="table-responsive">
          <table class="table mb-0">
            <thead>
              <tr>
                <th></th>
                <th></th>
              </tr>
            </thead>
            <tbody id="myTableChampagne">
              <?php while ($dado = $champagne->fetch_array()) { ?>
                <tr>
                  <td><?php echo $dado['nome']; ?>
                    <span class="descricao-vinho"><?php echo $dado['descricao'] ?></span>
                    <p class="preco-vinho">R$ <?php echo $dado['preco'] ?></p>
                    <div class="foto-origem">
                      <img src="../painel/assets/images/fotos/<?php echo $dado['bandeira']; ?>" alt="" width="50px">
                    </div>
                  </td>

                  <td><img src="../painel/assets/images/fotos/<?php echo  $dado['foto']; ?>" alt="" width="80px" style="border-radius:100%"></td>
                </tr>

              <?php } ?>


            </tbody>
          </table>
        </div>        

      </div>
    </div>


  </main>

  <!-- jQuery  -->
  <script src="./assets/js/jquery.min.js"></script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>

  <script>
    $(document).ready(function() {
      $("#myInput").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#myTable tr").filter(function() {
          $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
      });
    });
  </script>

  <script>
    $(document).ready(function() {
      $("#myInputRose").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#myTableRose tr").filter(function() {
          $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
      });
    });
  </script>


  <script>
    $(document).ready(function() {
      $("#myInputTintos").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#myTableTintos tr").filter(function() {
          $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
      });
    });
  </script>
  
  <script>
    $(document).ready(function() {
      $("#myInputChampagne").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#myTableChampagne tr").filter(function() {
          $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
      });
    });
  </script>


</body>

</html>