<?php

require_once 'db.php';

function removeFilesFromFolder($dir)
{
	array_map('unlink', glob("$dir/*"));
}

function array2csv(array &$array, $file)
{
	if (count($array) == 0) {
		return null;
	}
	ob_start();
	$df = fopen("csv/$file", 'w');
	fputs($df, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
	fputcsv($df, array_keys(reset($array)));
	foreach ($array as $row) {
		fputcsv($df, $row);
	}
	fclose($df);
	return ob_get_clean();
}

function utf8_converter($array)
{
	array_walk_recursive($array, function (&$item, $key) {
		if (!mb_detect_encoding($item, 'utf-8', true)) {
			$item = utf8_encode($item);
		}
	});
	return $array;
}
