<?php

require_once 'db.php';




function get_base_categories()
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "	SELECT  	id,
																					nome,
																					category_id,
																					cor,
																					case cor
																						when '#b50900' then 1
																						when '#d41f15' then 2
																						when '#de3e35' then 3
																						when '#fc584e' then 4
																						when '#ff8780' then 5
																					end as ordem
																from category
																where category_id is null
																order by ordem ");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data[] = $r;
		}
	}
	return $data;
}

function get_cat_by_id($id)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "select * from category where id = $id ");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data = $r;
		}
	}
	return $data;
}

function edit_btn($id)
{
	return "<div data-toggle='tooltip' data-placement='top' title='Editar Subcategoria'><button class='btn btnAcoesPlanoContas' data-toggle='modal' data-target='#modalEditSubcategoria$id'><i class='fas fa-edit'></i></button></div>
	<div data-toggle='tooltip' data-placement='top' title='Nova Camada'><button class='btn btnAcoesPlanoContas' data-toggle='modal' data-target='#modalPlusSubcategoriaDesp$id'><i class='fas fa-sitemap'></i></button></div>";
}

function edit_btn_sub_de_sub($id)
{
	return "<div data-toggle='tooltip' data-placement='top' title='Editar Subcategoria'><button class='btn btnAcoesPlanoContas' data-toggle='modal' data-target='#modalEditSubcategoriadeSubDesp$id'><i class='fas fa-edit'></i></button></div>";
}

function del_btn($id)
{
	return "<button class='btn btnAcoesPlanoContas' data-toggle='modal' data-target='#modalRemoveCategoria$id'><i class='fas fa-trash'></i></button>";
}

function get_cats_by_cat_id($id)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "select * from category where category_id = $id ");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data[] = $r;
		}
	}
	return $data;
}

function list_tree_cat_id($id)
{
	$subs = get_cats_by_cat_id($id);
	if (count($subs) > 0) {
		echo "<ul>";
		foreach ($subs as $s) {

			if ($s['esubdesub'] == null) {
				echo "<li class='listPlanoContasFilho'> $s[nome] " . edit_btn($s["id"]) . " </li>";
			} else {
				echo "<li class='listPlanoContasFilho'> $s[nome] " . edit_btn_sub_de_sub($s['id']) . " </li>";
			}
			list_tree_cat_id($s["id"]); ?>


			<!-- Criar nova subcategoria a partir da primeira subcategoria despesa -->
			<div class="modal fade" id="modalPlusSubcategoriaDesp<?php echo $s['id']; ?>" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalLabel">Nova Subcategoria de Subcategoria de Despesa</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">

							<form method="POST" action="/financeiro/plano-de-contas.php">
								<div class="form-group">
									<div class="col-md-12">
										<label>Nome</label>
										<input type="text" class="form-control" name="nome" id="nome">
										<input type="hidden" class="form-control" name="id" id="id" value="<?php echo $s['id'] ?>">
									</div>
								</div>

								<div class="form-group">
									<button type="submit" style="margin-right: 10px" class="btn btn-success float-right btn-addInfoGreen" name="salvaSubDeSubDesp" id="salvaSubDeSubDesp">Salvar</button>
								</div>

							</form>
						</div>
					</div>
				</div>
			</div>
			<!-- Criar nova subcategoria a partir da primeira subcategoria despesa-->

			<!-- Editar subcategoria de subcategoria -->
			<div class="modal fade" id="modalEditSubcategoriadeSubDesp<?php echo $s['id']; ?>" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalLabel">Editar Subcategoria de Subcategoria</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">

							<form method="POST" action="/financeiro/plano-de-contas.php">
								<div class="form-group">
									<div class="col-md-12">
										<label>Nome</label>
										<input type="text" class="form-control" name="nome" id="nome" value="<?php echo $s['nome'] ?>">
										<input type="hidden" class="form-control" name="id" id="id" value="<?php echo $s['id'] ?>">
									</div>
								</div>

								<div class="form-group">
									<button type="submit" style="margin-right: 10px" class="btn btn-success float-right btn-addInfoGreen" name="editSubCategoriadeSubDesp" id="editSubCategoriadeSubDesp">Editar</button>
									<button type="button" style="margin-right: 10px" class="btn btn-danger float-left btn-addInfo" data-dismiss="modal" data-toggle="modal" data-target="#modalConfirmRemoveSubcategoriaSubdeub<?php echo $s['id']; ?>">Remover</button>
								</div>

							</form>
						</div>
					</div>
				</div>
			</div>
			<!-- Editar subcategoria de subcategoria -->

			<!-- Remover Categoria -->
			<div class="modal fade" id="modalConfirmRemoveSubcategoriaSubdeub<?php echo $s['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="TituloModalLongoExemplo" aria-hidden="true">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<form class="forms-sample" action="/financeiro/plano-de-contas.php" method="POST">

								<input type="hidden" value="<?php echo $s['id'] ?>" name="id">
								<h5 class="modal-title" id="TituloModalLongoExemplo">Deseja realmente deletar a subcategoria <?php echo $s['nome'] ?>? </h5>
								<br><br>
								<button type="submit" class="btn btn-primary mr-2" name="btn-removerSubdeSub">Sim</button>
								<button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
							</form>
						</div>
						<div class="modal-footer">
						</div>
					</div>
				</div>
			</div>
			<!-- Remover Categoria -->



			<!-- Editar Subcategoria -->
			<div class="modal fade" id="modalEditSubcategoria<?php echo $s['id']; ?>" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalLabel">Subcategoria</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">

							<form method="POST" action="/financeiro/plano-de-contas.php">
								<div class="form-group">
									<div class="col-md-12">
										<label>Nome</label>
										<input type="text" class="form-control" name="nome" id="nome" value="<?php echo $s['nome'] ?>">
										<input type="hidden" class="form-control" name="id" id="id" value="<?php echo $s['id'] ?>">
									</div>
								</div>

								<div class="form-group">
									<button type="submit" style="margin-right: 10px" class="btn btn-success float-right btn-addInfoGreen" name="editSubCategoria" id="editSubCategoria">Editar</button>
									<button type="button" style="margin-right: 10px" class="btn btn-danger float-left btn-addInfo" data-dismiss="modal" data-toggle="modal" data-target="#modalConfirmRemove<?php echo $s['id']; ?>">Remover</button>
								</div>

							</form>
						</div>
					</div>
				</div>
			</div>
			<!-- Editar Subcategoria -->


			<!-- Remover Categoria -->
			<div class="modal fade" id="modalConfirmRemove<?php echo $s['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="TituloModalLongoExemplo" aria-hidden="true">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<form class="forms-sample" action="/financeiro/plano-de-contas.php" method="POST">

								<input type="hidden" value="<?php echo $s['id'] ?>" name="id">
								<h5 class="modal-title" id="TituloModalLongoExemplo">Deseja realmente deletar a subcategoria <?php echo $s['nome'] ?>? </h5>
								<br><br>
								<button type="submit" class="btn btn-primary mr-2" name="btn-removerSub">Sim</button>
								<button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
							</form>
						</div>
						<div class="modal-footer">
						</div>
					</div>
				</div>
			</div>
			<!-- Remover Categoria -->

		<?php }
		echo "</ul>";
	}
}

function select_tree_cat_id($id, $level)
{
	$subs = get_cats_by_cat_id($id);
	if (count($subs) > 0) {
		foreach ($subs as $s) {
			echo "<option value=\"$s[id]\" > " . str_repeat("-", $level) . "$s[nome] </option>";
			select_tree_cat_id($s["id"], $level + 1);
		}
	}
}

function selected_tree_cat_id($id, $level, $curr_id, $selected_id)
{
	//echo $selected_id;
	$subs = get_cats_by_cat_id($id);
	if (count($subs) > 0) {
		foreach ($subs as $s) {
			if ($s["id"] != $curr_id) {
				$selected = "";
				if ($s["id"] == $selected_id) {
					$selected = "selected";
				}
				echo "<option value=\"$s[id]\" $selected>" . str_repeat("-", $level) . "$s[nome] </option>";
				selected_tree_cat_id($s["id"], $level + 1, $curr_id, $selected_id);
			}
		}
	}
}






// Funções para o orçamento

// despesas
function get_base_orcamento($ano)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "	select	orcamentos.valor,
																				orcamentos.ano,
																				orcamentos.id as orcamentoid,
																				orcamentos.category_id as orcamento_category_id,
																				orcamentos.category_id_pai as orcamentos_category_id_pai,
																				category.nome
																from orcamentos
																inner join category 
																	on category.id = orcamentos.category_id
																where category_id_pai is NULL
																	and ano = $ano");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data[] = $r;
		}
	}
	return $data;
}

function get_orc_by_id($id)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "select * from orcamentos where id = $id ");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data = $r;
		}
	}
	return $data;
}

function edit_btn_orc($id)
{
	return "<div data-toggle='tooltip' data-placement='top' title='Editar Subcategoria'><a class='btn btnAcoesPlanoContas' href='rateio-orcamentos-edit.php?id=$id'><i class='fas fa-edit'></i></a></div>";
}


function get_orcs_by_orc_id($id, $ano)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "	select	orcamentos.id,
																				orcamentos.valor,
																				orcamentos.ano,
																				orcamentos.category_id,
																				orcamentos.category_id_pai,
																				category.nome
																from orcamentos 
																inner join category
																	on orcamentos.category_id = category.id 
																where category_id_pai = $id
																and ano = $ano");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data[] = $r;
		}
	}
	return $data;
}

function list_tree_orc_id($id, $ano)
{
	$subs = get_orcs_by_orc_id($id, $ano);
	if (count($subs) > 0) {
		echo "<ul>";
		foreach ($subs as $s) {
			echo "<li class='listPlanoContasFilho'> $s[nome]: R$ " . number_format("$s[valor]", 2, ',', '.') . edit_btn_orc($s["id"]) . " </li>";
			list_tree_cat_id($s["id"]); ?>
			<!-- Editar Subcategoria -->
			<div class="modal fade" id="modalEditRateio<?php echo $s['id']; ?>" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalLabel">Subcategoria</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">

							<form method="POST" action="/financeiro/orcamentos.php">
								<div class="form-group">
									<div class="col-md-12">
										<label>Nome</label>
										<input type="text" class="form-control" name="nome" id="nome" value="<?php echo $s['nome'] ?>">
										<input type="hidden" class="form-control" name="id" id="id" value="<?php echo $s['id'] ?>">
									</div>
								</div>

								<div class="form-group">
									<button type="submit" style="margin-right: 10px" class="btn btn-success float-right" name="editSubRateio" id="editSubRateio">Editar</button>
									<button type="button" style="margin-right: 10px" class="btn btn-danger float-left" data-dismiss="modal" data-toggle="modal" data-target="#modalConfirmRemove<?php echo $s['id']; ?>">Remover</button>
								</div>

							</form>
						</div>
					</div>
				</div>
			</div>
			<!-- Editar Subcategoria -->


			<!-- Remover Categoria -->
			<div class="modal fade" id="modalConfirmRemove<?php echo $s['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="TituloModalLongoExemplo" aria-hidden="true">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<form class="forms-sample" action="/financeiro/plano-de-contas.php" method="POST">

								<input type="hidden" value="<?php echo $s['id'] ?>" name="id">
								<h5 class="modal-title" id="TituloModalLongoExemplo">Deseja realmente deletar a subcategoria <?php echo $s['nome'] ?>? </h5>
								<br><br>
								<button type="submit" class="btn btn-primary mr-2" name="btn-removerSub">Sim</button>
								<button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
							</form>
						</div>
						<div class="modal-footer">
						</div>
					</div>
				</div>
			</div>
			<!-- Remover Categoria -->

		<?php }
		echo "</ul>";
	}
}

// receitas
function get_base_orcamento_rec($ano)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "	select	orcamentos_receitas.valor,
																				orcamentos_receitas.ano,
																				orcamentos_receitas.id as orcamentoid,
																				orcamentos_receitas.category_id as orcamento_category_id,
																				orcamentos_receitas.category_id_pai as orcamentos_category_id_pai,
																				category_receita.nome
																			from orcamentos_receitas
																			inner join category_receita
																			on category_receita.id = orcamentos_receitas.category_id
																			where category_id_pai is NULL
																	and ano = $ano");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data[] = $r;
		}
	}
	return $data;
}

function edit_btn_orc_rec($id)
{
	return "<div data-toggle='tooltip' data-placement='top' title='Editar Subcategoria'><a class='btn btnAcoesPlanoContas' href='rateio-orcamento-receita-edit.php?id=$id'><i class='fas fa-edit'></i></a></div>";
}

function get_orcs_rec_by_orc_rec_id($id, $ano)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "	select	orcamentos_receitas.id,
																				orcamentos_receitas.valor,
																				orcamentos_receitas.ano,
																				orcamentos_receitas.category_id,
																				orcamentos_receitas.category_id_pai,
																				category_receita.nome
																from orcamentos_receitas 
																inner join category_receita
																	on orcamentos_receitas.category_id = category_receita.id 
																where category_id_pai = $id
																and ano = $ano");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data[] = $r;
		}
	}
	return $data;
}


function list_tree_orc_rec_id($id, $ano)
{
	$subs = get_orcs_rec_by_orc_rec_id($id, $ano);
	if (count($subs) > 0) {
		echo "<ul>";
		foreach ($subs as $s) {
			echo "<li class='listPlanoContasFilho'> $s[nome]: R$ " . number_format("$s[valor]", 2, ',', '.') . edit_btn_orc_rec($s["id"]) . " </li>";
			list_tree_cat_id($s["id"]); ?>
			<!-- Editar Subcategoria -->
			<div class="modal fade" id="modalEditRateio<?php echo $s['id']; ?>" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalLabel">Subcategoria</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">

							<form method="POST" action="/financeiro/orcamentos-receitas.php">
								<div class="form-group">
									<div class="col-md-12">
										<label>Nome</label>
										<input type="text" class="form-control" name="nome" id="nome" value="<?php echo $s['nome'] ?>">
										<input type="hidden" class="form-control" name="id" id="id" value="<?php echo $s['id'] ?>">
									</div>
								</div>

								<div class="form-group">
									<button type="submit" style="margin-right: 10px" class="btn btn-success float-right" name="editSubRateio" id="editSubRateio">Editar</button>
									<button type="button" style="margin-right: 10px" class="btn btn-danger float-left" data-dismiss="modal" data-toggle="modal" data-target="#modalConfirmRemove<?php echo $s['id']; ?>">Remover</button>
								</div>

							</form>
						</div>
					</div>
				</div>
			</div>
			<!-- Editar Subcategoria -->


			<!-- Remover Categoria -->
			<div class="modal fade" id="modalConfirmRemove<?php echo $s['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="TituloModalLongoExemplo" aria-hidden="true">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<form class="forms-sample" action="/financeiro/plano-de-contas.php" method="POST">

								<input type="hidden" value="<?php echo $s['id'] ?>" name="id">
								<h5 class="modal-title" id="TituloModalLongoExemplo">Deseja realmente deletar a subcategoria <?php echo $s['nome'] ?>? </h5>
								<br><br>
								<button type="submit" class="btn btn-primary mr-2" name="btn-removerSub">Sim</button>
								<button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
							</form>
						</div>
						<div class="modal-footer">
						</div>
					</div>
				</div>
			</div>
			<!-- Remover Categoria -->

		<?php }
		echo "</ul>";
	}
}


// Funções para o plano de contas de receitas

function get_base_categories_rec()
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "	SELECT  	id,
																					nome,
																					category_id,
																					cor,
																					case cor
																						when '#346304' then 1
																						when '#4e8a11' then 2
																						when '#64b314' then 3
																						when '#74d413' then 4
																						when '#99fa37' then 5
																					end as ordem
																from category_receita
																where category_id is null
																order by ordem ");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data[] = $r;
		}
	}
	return $data;
}

function get_cat_by_id_rec($id)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "select * from category_receita where id = $id");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data = $r;
		}
	}
	return $data;
}

function edit_btn_rec($id)
{
	return "<div data-toggle='tooltip' data-placement='top' title='Editar Subcategoria'><button class='btn btnAcoesPlanoContas' data-toggle='modal' data-target='#modalEditSubcategoria$id'><i class='fas fa-edit'></i></button></div>
					<div data-toggle='tooltip' data-placement='top' title='Nova Camada'><button class='btn btnAcoesPlanoContas' data-toggle='modal' data-target='#modalPlusSubcategoria$id'><i class='fas fa-sitemap'></i></button></div>";
}

function edit_btn_rec_sub_de_sub($id)
{
	return "<div data-toggle='tooltip' data-placement='top' title='Editar Subcategoria'><button class='btn btnAcoesPlanoContas' data-toggle='modal' data-target='#modalEditSubcategoriadeSub$id'><i class='fas fa-edit'></i></button></div>";
}

function del_btn_rec($id)
{
	return "<button class='btn btnAcoesPlanoContas' data-toggle='modal' data-target='#modalRemoveCategoria$id'><i class='fas fa-trash'></i></button>";
}

function get_cats_by_cat_id_rec($id)
{
	$data = array();
	$con = db_connect();
	$query = mysqli_query($con, "select * from category_receita where category_id = $id");
	if ($query->num_rows > 0) {
		while ($r = $query->fetch_array()) {
			$data[] = $r;
		}
	}
	return $data;
}

function list_tree_cat_id_rec($id)
{
	$subs = get_cats_by_cat_id_rec($id);
	if (count($subs) > 0) {
		echo "<ul>";
		foreach ($subs as $s) {
			if ($s['esubdesub'] == null) {
				echo "<li class='listPlanoContasFilho'> $s[nome] " . edit_btn_rec($s["id"]) . " </li>";
			} else {
				echo "<li class='listPlanoContasFilho'> $s[nome] " . edit_btn_rec_sub_de_sub($s['id']) . " </li>";
			}
			list_tree_cat_id_rec($s["id"]);
		?>

			<!-- Criar nova subcategoria a partir da primeira subcategoria -->
			<div class="modal fade" id="modalPlusSubcategoria<?php echo $s['id']; ?>" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalLabel">Nova Subcategoria de Subcategoria</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">

							<form method="POST" action="/financeiro/plano-de-contas-receitas.php">
								<div class="form-group">
									<div class="col-md-12">
										<label>Nome</label>
										<input type="text" class="form-control" name="nome" id="nome">
										<input type="hidden" class="form-control" name="id" id="id" value="<?php echo $s['id'] ?>">
									</div>
								</div>

								<div class="form-group">
									<button type="submit" style="margin-right: 10px" class="btn btn-success float-right btn-addInfoGreen" name="salvaSubDeSub" id="salvaSubDeSub">Salvar</button>
								</div>

							</form>
						</div>
					</div>
				</div>
			</div>
			<!-- Criar nova subcategoria a partir da primeira subcategoria -->


			<!-- Editar subcategoria de subcategoria -->
			<div class="modal fade" id="modalEditSubcategoriadeSub<?php echo $s['id']; ?>" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalLabel">Editar Subcategoria de Subcategoria</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">

							<form method="POST" action="/financeiro/plano-de-contas-receitas.php">
								<div class="form-group">
									<div class="col-md-12">
										<label>Nome</label>
										<input type="text" class="form-control" name="nome" id="nome" value="<?php echo $s['nome'] ?>">
										<input type="hidden" class="form-control" name="id" id="id" value="<?php echo $s['id'] ?>">
									</div>
								</div>

								<div class="form-group">
									<button type="submit" style="margin-right: 10px" class="btn btn-success float-right btn-addInfoGreen" name="editSubCategoriadeSub" id="editSubCategoriadeSub">Editar</button>
									<button type="button" style="margin-right: 10px" class="btn btn-danger float-left btn-addInfo" data-dismiss="modal" data-toggle="modal" data-target="#modalConfirmRemoveSubcategoria<?php echo $s['id']; ?>">Remover</button>
								</div>

							</form>
						</div>
					</div>
				</div>
			</div>
			<!-- Editar subcategoria de subcategoria -->


			<!-- Remover subcategoria de subcategoria -->
			<div class="modal fade" id="modalConfirmRemoveSubcategoria<?php echo $s['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="TituloModalLongoExemplo" aria-hidden="true">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body text-center">
							<svg id="e036d8c3-b5bc-4d4e-ad12-45724d0dcfd5" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" width="200" height="200" viewBox="0 0 930.67538 521.87593">
								<path id="a08a2523-9d19-4e0c-87cb-6ce1a7fd2fc4" data-name="Path 133" d="M213.37258,618.97624a158.39338,158.39338,0,0,0,28.72768,33.86154c.254.23174.515.45361.77586.68127l23.73866-14.10511c-.1756-.23879-.36947-.50634-.57728-.79926-12.39459-17.25583-68.37231-132.05609-68.71437-157.47835C197.28,483.24064,177.17769,562.25219,213.37258,618.97624Z" transform="translate(-134.66231 -189.06204)" fill="#e6e6e6" />
								<path id="a62b1d0a-4504-46a8-81c8-bbc6043ad63f" data-name="Path 134" d="M237.51988,655.55937c.36662.16483.741.3251,1.118.478l17.80937-10.582c-.278-.16053-.60252-.3504-.97444-.56327-6.09666-3.56147-24.23716-14.2625-42.09847-25.91685-19.19136-12.52636-38.071-26.1452-41.34715-33.18782C172.70895,587.40853,193.83961,636.659,237.51988,655.55937Z" transform="translate(-134.66231 -189.06204)" fill="#e6e6e6" />
								<path id="fd401fbc-93ba-42a5-a9a4-5a6900171ed6" data-name="Path 133" d="M989.86254,665.2559a158.39406,158.39406,0,0,1-7.4,43.785c-.1.329-.211.653-.319.982h-27.613c.029-.295.059-.624.088-.982,1.841-21.166-8.677-148.453-21.369-170.483C934.36152,540.3449,992.00352,598.00187,989.86254,665.2559Z" transform="translate(-134.66231 -189.06204)" fill="#e6e6e6" />
								<path id="eaa08601-a63b-4214-86e2-4a8f8e2c7e12" data-name="Path 134" d="M987.79049,709.04088c-.231.329-.471.658-.717.982h-20.716c.157-.28.339-.609.55-.982,3.422-6.176,13.551-24.642,22.953-43.785,10.1-20.572,19.374-41.924,18.593-49.652C1008.69548,617.34587,1015.68746,670.4799,987.79049,709.04088Z" transform="translate(-134.66231 -189.06204)" fill="#e6e6e6" />
								<path d="M582.73018,709.255H263.402a28.57994,28.57994,0,0,1-28.54766-28.54766V217.6097A28.57994,28.57994,0,0,1,263.402,189.062H582.73018a28.57994,28.57994,0,0,1,28.54766,28.54766V680.70738A28.57994,28.57994,0,0,1,582.73018,709.255Z" transform="translate(-134.66231 -189.06204)" fill="#cacaca" />
								<path d="M583.29225,691.041H262.83992a8.8102,8.8102,0,0,1-8.80013-8.80013V216.07621a8.8102,8.8102,0,0,1,8.80013-8.80013H583.29225a8.81019,8.81019,0,0,1,8.80013,8.80013V682.24087A8.81019,8.81019,0,0,1,583.29225,691.041Z" transform="translate(-134.66231 -189.06204)" fill="#fff" />
								<circle cx="287.18951" cy="8.74274" r="2.42854" fill="#fff" />
								<path d="M1064.147,710.938H135.853a1.19068,1.19068,0,1,1,0-2.38136h928.294a1.19068,1.19068,0,1,1,0,2.38136Z" transform="translate(-134.66231 -189.06204)" fill="#cacaca" />
								<circle cx="288.40115" cy="355.3465" r="31" fill="#e4e4e4" />
								<path d="M442.47166,484.90854H403.65538L380.22154,370.27817a43.05942,43.05942,0,1,1,85.69153-.05078Z" transform="translate(-134.66231 -189.06204)" fill="#e4e4e4" />
								<path d="M575.5801,330.82838H717.454a30.15959,30.15959,0,0,1,29.42119,23.52657l71.68609,317.96779a24.3755,24.3755,0,0,1-22.57916,29.70689L650.1348,709.21552a32.20254,32.20254,0,0,1-33.27305-26.43158L576.197,457.97716l-7.692-42.52344-11.35095-62.75164a18.56906,18.56906,0,0,1,18.426-21.8737Z" transform="translate(-134.66231 -189.06204)" fill="#3f3d56" />
								<path d="M698.77657,337.68294h16.561a20.84257,20.84257,0,0,1,20.36353,16.39964l68.80881,315.37356a12.91479,12.91479,0,0,1-11.77337,15.64015l-145.37556,9.52782A16.72593,16.72593,0,0,1,629.80607,680.899l-58.715-325.96934a14.64977,14.64977,0,0,1,14.41777-17.24675h15.71067a6.91389,6.91389,0,0,1,6.67617,5.11645h0a6.10376,6.10376,0,0,0,5.89388,4.51694h74.58408a10.43362,10.43362,0,0,0,10.40289-9.6334Z" transform="translate(-134.66231 -189.06204)" fill="#fff" />
								<path d="M772.14887,438.77577a10.52534,10.52534,0,0,1,1.31643,1.00712l48.05635-12.25059L824.8,415.93891l18.14315,2.66086L839.134,439.6876a8,8,0,0,1-7.03474,6.53394L775.988,452.13061a10.49709,10.49709,0,1,1-3.83908-13.35484Z" transform="translate(-134.66231 -189.06204)" fill="#ffb6b6" />
								<circle cx="603.19202" cy="262.1948" r="31" fill="#5076ff" />
								<path d="M757.26253,391.75684H718.44625L695.01241,277.12647a43.05942,43.05942,0,1,1,85.69153-.05078Z" transform="translate(-134.66231 -189.06204)" fill="#5076ff" />
								<polygon points="711.524 240.061 699.144 250.741 681.824 265.671 674.174 226.531 673.374 222.461 672.744 219.231 690.294 188.661 704.924 189.501 705.924 189.561 705.944 189.781 706.174 191.831 709.174 218.811 709.244 219.461 711.524 240.061" fill="#3f3d56" />
								<polygon points="630.606 507.736 618.346 507.735 612.513 460.447 630.608 460.448 630.606 507.736" fill="#ffb6b6" />
								<path d="M768.39448,708.6817l-39.53076-.00146v-.5A15.38731,15.38731,0,0,1,744.2502,692.794h.001l24.144.001Z" transform="translate(-134.66231 -189.06204)" fill="#2f2e41" />
								<polygon points="758.606 508.736 746.346 508.735 740.513 461.447 758.608 461.448 758.606 508.736" fill="#ffb6b6" />
								<path d="M896.39448,709.6817l-39.53076-.00146v-.5A15.38731,15.38731,0,0,1,872.2502,693.794h.001l24.144.001Z" transform="translate(-134.66231 -189.06204)" fill="#2f2e41" />
								<path d="M903.06648,676.9734l-33,5-48.00977-162.48-50.99023,163.48-37-5,48-190v-15l6.5-22.5-.68018-6.09-4.73-42.59-2.04981-18.47-.13285-1.19313a4.05551,4.05551,0,0,1,3.19291-4.41685h0l15.39991-3.24H824.7364l14.8501,4.09,1.02.28.46.13-.23,1.92-3.48,29.18-.18994,1.6-3.3601,28.13-.74,6.17c29,21,30,42,30,42Z" transform="translate(-134.66231 -189.06204)" fill="#2f2e41" />
								<circle cx="674.44747" cy="148.19876" r="24.56103" fill="#ffb6b6" />
								<rect x="786.56648" y="443.4734" width="49" height="7" transform="matrix(0.99156, -0.12967, 0.12967, 0.99156, -185.77459, -80.11503)" fill="#3f3d56" />
								<path d="M721.14887,448.77577a10.52534,10.52534,0,0,1,1.31643,1.00712l48.05635-12.25059L773.8,425.93891l18.14315,2.66086L788.134,449.6876a8,8,0,0,1-7.03474,6.53394L724.988,462.13061a10.49709,10.49709,0,1,1-3.83908-13.35484Z" transform="translate(-134.66231 -189.06204)" fill="#ffb6b6" />
								<path d="M795.06648,383.9734l-8.5-6.5c-2.29817-.87172-5.44731,1.605-6,4l-12,49,25,18,3.5-5.5Z" transform="translate(-134.66231 -189.06204)" fill="#3f3d56" />
								<g opacity="0.2">
									<path d="M843.8365,407.87336a67.67557,67.67557,0,0,1-6.48,2.2c-.69995.21-1.41992.41-2.12988.6a66.019,66.019,0,0,1-14.34033,2.32,45.1399,45.1399,0,0,1-6.25977-.17,35.24271,35.24271,0,0,1-6.58984-1.3c-.07031-.02-.15039-.04-.22021-.06a28.90621,28.90621,0,0,1-11.9502-6.79,23.55972,23.55972,0,0,1-2.10986-2.35,21.23879,21.23879,0,0,1-4.56006-16.53,14.15326,14.15326,0,0,1,.34033-1.57,25.10719,25.10719,0,0,1,1.48975-4.1c.27-.62.57031-1.23.89013-1.82995l11.29981-3.82h21.52l14.8501,4.09,1,.06.02.22.46.13-.23,1.92Z" transform="translate(-134.66231 -189.06204)" />
								</g>
								<path d="M790.2894,316.92681c-4.59329-.563-9.634-.16485-13.21411,2.76738s-4.73558,9.02781-1.34592,12.17829c3.00083,2.7891,7.69329,2.13322,11.71262,2.92632a15.85418,15.85418,0,0,1,12.38363,15.15657c-.05982,10.17413-9.82411,17.87894-11.578,27.90093-1.197,6.83982,1.68772,14.03819,6.675,18.86966s11.84323,7.44255,18.7509,8.1498,13.8926-.373,20.60575-2.14766c6.74127-1.78215,13.3778-4.31055,19.03424-8.388s10.2931-9.82559,12.10928-16.55777.51227-14.45089-4.16774-19.61986c-5.35905-5.919-14.27436-7.95446-18.90989-14.45565-5.19639-7.28778-3.27352-17.66625-7.4792-25.56731-2.80792-5.27513-8.12457-8.87314-13.79191-10.76857s-11.719-2.26953-17.69212-2.4531c-3.13956-.09649-6.37527-.12863-9.30035,1.016s-5.49633,3.75316-5.648,6.89055S790.2894,316.92681,790.2894,316.92681Z" transform="translate(-134.66231 -189.06204)" fill="#2f2e41" />
							</svg>
							<form class="forms-sample" action="/financeiro/plano-de-contas-receitas.php" method="POST">

								<input type="hidden" value="<?php echo $s['id'] ?>" name="id">
								<h5 class="modal-title" id="TituloModalLongoExemplo">Deseja realmente deletar a subcategoria <?php echo $s['nome'] ?>? </h5>
								<br><br>
								<button type="button" class="btn btn-danger btn-addInfo" data-dismiss="modal">Não</button>
								<button type="submit" class="btn btn-success btn-addInfoGreen" name="btn-removerSubdeSub">Sim</button>
							</form>
						</div>
						<div class="modal-footer">
						</div>
					</div>
				</div>
			</div>
			<!-- Remover subcategoria de subcategoria -->


			<!-- Editar Subcategoria -->
			<div class="modal fade" id="modalEditSubcategoria<?php echo $s['id']; ?>" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="modalLabel">Editar Subcategoria de Receita</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">

							<form method="POST" action="/financeiro/plano-de-contas-receitas.php">
								<div class="form-group">
									<div class="col-md-12">
										<label>Nome</label>
										<input type="text" class="form-control" name="nome" id="nome" value="<?php echo $s['nome'] ?>">
										<input type="hidden" class="form-control" name="id" id="id" value="<?php echo $s['id'] ?>">
									</div>
								</div>

								<div class="form-group">
									<button type="submit" style="margin-right: 10px" class="btn btn-success float-right btn-addInfoGreen" name="editSubCategoria" id="editSubCategoria">Editar</button>
									<button type="button" style="margin-right: 10px" class="btn btn-danger float-left btn-addInfo" data-dismiss="modal" data-toggle="modal" data-target="#modalConfirmRemove<?php echo $s['id']; ?>">Remover</button>
								</div>

							</form>
						</div>
					</div>
				</div>
			</div>
			<!-- Editar Subcategoria -->





			<!-- Remover Categoria -->
			<div class="modal fade" id="modalConfirmRemove<?php echo $s['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="TituloModalLongoExemplo" aria-hidden="true">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body text-center">
							<svg id="e036d8c3-b5bc-4d4e-ad12-45724d0dcfd5" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" width="200" height="200" viewBox="0 0 930.67538 521.87593">
								<path id="a08a2523-9d19-4e0c-87cb-6ce1a7fd2fc4" data-name="Path 133" d="M213.37258,618.97624a158.39338,158.39338,0,0,0,28.72768,33.86154c.254.23174.515.45361.77586.68127l23.73866-14.10511c-.1756-.23879-.36947-.50634-.57728-.79926-12.39459-17.25583-68.37231-132.05609-68.71437-157.47835C197.28,483.24064,177.17769,562.25219,213.37258,618.97624Z" transform="translate(-134.66231 -189.06204)" fill="#e6e6e6" />
								<path id="a62b1d0a-4504-46a8-81c8-bbc6043ad63f" data-name="Path 134" d="M237.51988,655.55937c.36662.16483.741.3251,1.118.478l17.80937-10.582c-.278-.16053-.60252-.3504-.97444-.56327-6.09666-3.56147-24.23716-14.2625-42.09847-25.91685-19.19136-12.52636-38.071-26.1452-41.34715-33.18782C172.70895,587.40853,193.83961,636.659,237.51988,655.55937Z" transform="translate(-134.66231 -189.06204)" fill="#e6e6e6" />
								<path id="fd401fbc-93ba-42a5-a9a4-5a6900171ed6" data-name="Path 133" d="M989.86254,665.2559a158.39406,158.39406,0,0,1-7.4,43.785c-.1.329-.211.653-.319.982h-27.613c.029-.295.059-.624.088-.982,1.841-21.166-8.677-148.453-21.369-170.483C934.36152,540.3449,992.00352,598.00187,989.86254,665.2559Z" transform="translate(-134.66231 -189.06204)" fill="#e6e6e6" />
								<path id="eaa08601-a63b-4214-86e2-4a8f8e2c7e12" data-name="Path 134" d="M987.79049,709.04088c-.231.329-.471.658-.717.982h-20.716c.157-.28.339-.609.55-.982,3.422-6.176,13.551-24.642,22.953-43.785,10.1-20.572,19.374-41.924,18.593-49.652C1008.69548,617.34587,1015.68746,670.4799,987.79049,709.04088Z" transform="translate(-134.66231 -189.06204)" fill="#e6e6e6" />
								<path d="M582.73018,709.255H263.402a28.57994,28.57994,0,0,1-28.54766-28.54766V217.6097A28.57994,28.57994,0,0,1,263.402,189.062H582.73018a28.57994,28.57994,0,0,1,28.54766,28.54766V680.70738A28.57994,28.57994,0,0,1,582.73018,709.255Z" transform="translate(-134.66231 -189.06204)" fill="#cacaca" />
								<path d="M583.29225,691.041H262.83992a8.8102,8.8102,0,0,1-8.80013-8.80013V216.07621a8.8102,8.8102,0,0,1,8.80013-8.80013H583.29225a8.81019,8.81019,0,0,1,8.80013,8.80013V682.24087A8.81019,8.81019,0,0,1,583.29225,691.041Z" transform="translate(-134.66231 -189.06204)" fill="#fff" />
								<circle cx="287.18951" cy="8.74274" r="2.42854" fill="#fff" />
								<path d="M1064.147,710.938H135.853a1.19068,1.19068,0,1,1,0-2.38136h928.294a1.19068,1.19068,0,1,1,0,2.38136Z" transform="translate(-134.66231 -189.06204)" fill="#cacaca" />
								<circle cx="288.40115" cy="355.3465" r="31" fill="#e4e4e4" />
								<path d="M442.47166,484.90854H403.65538L380.22154,370.27817a43.05942,43.05942,0,1,1,85.69153-.05078Z" transform="translate(-134.66231 -189.06204)" fill="#e4e4e4" />
								<path d="M575.5801,330.82838H717.454a30.15959,30.15959,0,0,1,29.42119,23.52657l71.68609,317.96779a24.3755,24.3755,0,0,1-22.57916,29.70689L650.1348,709.21552a32.20254,32.20254,0,0,1-33.27305-26.43158L576.197,457.97716l-7.692-42.52344-11.35095-62.75164a18.56906,18.56906,0,0,1,18.426-21.8737Z" transform="translate(-134.66231 -189.06204)" fill="#3f3d56" />
								<path d="M698.77657,337.68294h16.561a20.84257,20.84257,0,0,1,20.36353,16.39964l68.80881,315.37356a12.91479,12.91479,0,0,1-11.77337,15.64015l-145.37556,9.52782A16.72593,16.72593,0,0,1,629.80607,680.899l-58.715-325.96934a14.64977,14.64977,0,0,1,14.41777-17.24675h15.71067a6.91389,6.91389,0,0,1,6.67617,5.11645h0a6.10376,6.10376,0,0,0,5.89388,4.51694h74.58408a10.43362,10.43362,0,0,0,10.40289-9.6334Z" transform="translate(-134.66231 -189.06204)" fill="#fff" />
								<path d="M772.14887,438.77577a10.52534,10.52534,0,0,1,1.31643,1.00712l48.05635-12.25059L824.8,415.93891l18.14315,2.66086L839.134,439.6876a8,8,0,0,1-7.03474,6.53394L775.988,452.13061a10.49709,10.49709,0,1,1-3.83908-13.35484Z" transform="translate(-134.66231 -189.06204)" fill="#ffb6b6" />
								<circle cx="603.19202" cy="262.1948" r="31" fill="#5076ff" />
								<path d="M757.26253,391.75684H718.44625L695.01241,277.12647a43.05942,43.05942,0,1,1,85.69153-.05078Z" transform="translate(-134.66231 -189.06204)" fill="#5076ff" />
								<polygon points="711.524 240.061 699.144 250.741 681.824 265.671 674.174 226.531 673.374 222.461 672.744 219.231 690.294 188.661 704.924 189.501 705.924 189.561 705.944 189.781 706.174 191.831 709.174 218.811 709.244 219.461 711.524 240.061" fill="#3f3d56" />
								<polygon points="630.606 507.736 618.346 507.735 612.513 460.447 630.608 460.448 630.606 507.736" fill="#ffb6b6" />
								<path d="M768.39448,708.6817l-39.53076-.00146v-.5A15.38731,15.38731,0,0,1,744.2502,692.794h.001l24.144.001Z" transform="translate(-134.66231 -189.06204)" fill="#2f2e41" />
								<polygon points="758.606 508.736 746.346 508.735 740.513 461.447 758.608 461.448 758.606 508.736" fill="#ffb6b6" />
								<path d="M896.39448,709.6817l-39.53076-.00146v-.5A15.38731,15.38731,0,0,1,872.2502,693.794h.001l24.144.001Z" transform="translate(-134.66231 -189.06204)" fill="#2f2e41" />
								<path d="M903.06648,676.9734l-33,5-48.00977-162.48-50.99023,163.48-37-5,48-190v-15l6.5-22.5-.68018-6.09-4.73-42.59-2.04981-18.47-.13285-1.19313a4.05551,4.05551,0,0,1,3.19291-4.41685h0l15.39991-3.24H824.7364l14.8501,4.09,1.02.28.46.13-.23,1.92-3.48,29.18-.18994,1.6-3.3601,28.13-.74,6.17c29,21,30,42,30,42Z" transform="translate(-134.66231 -189.06204)" fill="#2f2e41" />
								<circle cx="674.44747" cy="148.19876" r="24.56103" fill="#ffb6b6" />
								<rect x="786.56648" y="443.4734" width="49" height="7" transform="matrix(0.99156, -0.12967, 0.12967, 0.99156, -185.77459, -80.11503)" fill="#3f3d56" />
								<path d="M721.14887,448.77577a10.52534,10.52534,0,0,1,1.31643,1.00712l48.05635-12.25059L773.8,425.93891l18.14315,2.66086L788.134,449.6876a8,8,0,0,1-7.03474,6.53394L724.988,462.13061a10.49709,10.49709,0,1,1-3.83908-13.35484Z" transform="translate(-134.66231 -189.06204)" fill="#ffb6b6" />
								<path d="M795.06648,383.9734l-8.5-6.5c-2.29817-.87172-5.44731,1.605-6,4l-12,49,25,18,3.5-5.5Z" transform="translate(-134.66231 -189.06204)" fill="#3f3d56" />
								<g opacity="0.2">
									<path d="M843.8365,407.87336a67.67557,67.67557,0,0,1-6.48,2.2c-.69995.21-1.41992.41-2.12988.6a66.019,66.019,0,0,1-14.34033,2.32,45.1399,45.1399,0,0,1-6.25977-.17,35.24271,35.24271,0,0,1-6.58984-1.3c-.07031-.02-.15039-.04-.22021-.06a28.90621,28.90621,0,0,1-11.9502-6.79,23.55972,23.55972,0,0,1-2.10986-2.35,21.23879,21.23879,0,0,1-4.56006-16.53,14.15326,14.15326,0,0,1,.34033-1.57,25.10719,25.10719,0,0,1,1.48975-4.1c.27-.62.57031-1.23.89013-1.82995l11.29981-3.82h21.52l14.8501,4.09,1,.06.02.22.46.13-.23,1.92Z" transform="translate(-134.66231 -189.06204)" />
								</g>
								<path d="M790.2894,316.92681c-4.59329-.563-9.634-.16485-13.21411,2.76738s-4.73558,9.02781-1.34592,12.17829c3.00083,2.7891,7.69329,2.13322,11.71262,2.92632a15.85418,15.85418,0,0,1,12.38363,15.15657c-.05982,10.17413-9.82411,17.87894-11.578,27.90093-1.197,6.83982,1.68772,14.03819,6.675,18.86966s11.84323,7.44255,18.7509,8.1498,13.8926-.373,20.60575-2.14766c6.74127-1.78215,13.3778-4.31055,19.03424-8.388s10.2931-9.82559,12.10928-16.55777.51227-14.45089-4.16774-19.61986c-5.35905-5.919-14.27436-7.95446-18.90989-14.45565-5.19639-7.28778-3.27352-17.66625-7.4792-25.56731-2.80792-5.27513-8.12457-8.87314-13.79191-10.76857s-11.719-2.26953-17.69212-2.4531c-3.13956-.09649-6.37527-.12863-9.30035,1.016s-5.49633,3.75316-5.648,6.89055S790.2894,316.92681,790.2894,316.92681Z" transform="translate(-134.66231 -189.06204)" fill="#2f2e41" />
							</svg>
							<form class="forms-sample" action="/financeiro/plano-de-contas-receitas.php" method="POST">

								<input type="hidden" value="<?php echo $s['id'] ?>" name="id">
								<h5 class="modal-title" id="TituloModalLongoExemplo">Deseja realmente deletar a subcategoria <?php echo $s['nome'] ?>? </h5>
								<br><br>
								<button type="button" class="btn btn-danger btn-addInfo" data-dismiss="modal">Não</button>
								<button type="submit" class="btn btn-success btn-addInfoGreen" name="btn-removerSub">Sim</button>
							</form>
						</div>
						<div class="modal-footer">
						</div>
					</div>
				</div>
			</div>
			<!-- Remover Categoria -->

	<?php }
		echo "</ul>";
	}
}

function select_tree_cat_id_rec($id, $level)
{
	$subs = get_cats_by_cat_id_rec($id);
	if (count($subs) > 0) {
		foreach ($subs as $s) {
			echo "<option value=\"$s[id]\" > " . str_repeat("-", $level) . "$s[nome] </option>";
			select_tree_cat_id_rec($s["id"], $level + 1);
		}
	}
}

function selected_tree_cat_id_rec($id, $level, $curr_id, $selected_id)
{
	//echo $selected_id;
	$subs = get_cats_by_cat_id_rec($id);
	if (count($subs) > 0) {
		foreach ($subs as $s) {
			if ($s["id"] != $curr_id) {
				$selected = "";
				if ($s["id"] == $selected_id) {
					$selected = "selected";
				}
				echo "<option value=\"$s[id]\" $selected>" . str_repeat("-", $level) . "$s[nome] </option>";
				selected_tree_cat_id_rec($s["id"], $level + 1, $curr_id, $selected_id);
			}
		}
	}
}









?>